import iesve
from ies_file_picker import IesFilePicker
import xlsxwriter
import os

file_name = IesFilePicker.pick_aps_file()
aps_file = iesve.ResultsReader.open(file_name)

weather_file_name = aps_file.weather_file
weather_file = iesve.WeatherFileReader()
weather_file.open_weather_file(weather_file_name)

book = xlsxwriter.Workbook('weather_data.xlsx')
sheet = book.add_worksheet('sheet1')

weather_variables = ["Cloud cover", "Wind direction", "Dry bulb temperatre", "Wet bulb temperature", "Direct radiation", "Diffuse radiation", "Solar altitude", "Solar aziuth", "Atmospheric pressure", "Wind speed", "External relative humidity", "External moisture", "Global radiation", "External dew point temperature"]
"""
     |        1: Cloud cover (Units: Oktas)
     |        2: Wind direction [E of N] (Units: Degrees)
     |        3: Dry bulb temperature (Units: Degrees C)
     |        4: Wet bulb temperature (Units: Degrees C)
     |        5: Direct normal radiation (Units: W/m2)
     |        6: Diffuse horizontal radiation (Units: W/m2)
     |        7: Solar altitude (Units: Degrees)
     |        8: Solar azimuth (Units: Degrees)
     |        9: Atmospheric pressure (Pa)
     |       10: Wind speed (m/s)
     |       11: Relative humidity (Units: %)
     |       12: Humidity ratio (moisture content) (Units: kg/kg)
     |       13: Global radiation (Units: W/m2)
     |       14: Dew point temperature (Units: Degrees C)
"""

for val in range(0, len(weather_variables)):
    variable = weather_file.get_results(val+1, 1, 365)
    col_name = weather_variables[val]
    sheet.write(0, val, col_name)
    sheet.write_column(1, val, variable)

book.close()
os.startfile('weather_data.xlsx')